/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import com.google.common.base.Splitter;
import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleUtil;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class TurtlePlaceCommand
implements TurtleCommand {
    private final InteractDirection direction;
    private final Object[] extraArguments;

    public TurtlePlaceCommand(InteractDirection direction, Object[] arguments) {
        this.direction = direction;
        this.extraArguments = arguments;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        ItemStack stack = turtle.getInventory().getItem(turtle.getSelectedSlot());
        if (stack.isEmpty()) {
            return TurtleCommandResult.failure("No items to place");
        }
        Direction direction = this.direction.toWorldDir(turtle);
        BlockPos playerPosition = turtle.getPosition().relative(direction);
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, playerPosition, direction);
        turtlePlayer.loadInventory(turtle);
        ErrorMessage message = new ErrorMessage();
        boolean result = TurtlePlaceCommand.deploy(stack, turtle, turtlePlayer, direction, this.extraArguments, message);
        turtlePlayer.unloadInventory(turtle);
        if (result) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        if (message.message != null) {
            return TurtleCommandResult.failure(message.message);
        }
        return TurtleCommandResult.failure(stack.getItem() instanceof BlockItem ? "Cannot place block here" : "Cannot place item here");
    }

    private static boolean deploy(ItemStack stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer, Direction direction, @Nullable Object[] extraArguments, @Nullable ErrorMessage outErrorMessage) {
        if (TurtlePlaceCommand.deployOnEntity(turtle, turtlePlayer)) {
            return true;
        }
        BlockPos position = turtle.getPosition();
        BlockPos newPosition = position.relative(direction);
        return TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition, direction.getOpposite(), extraArguments, true, outErrorMessage) || TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition.relative(direction), direction.getOpposite(), extraArguments, false, outErrorMessage) || direction.getAxis() != Direction.Axis.Y && TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition.below(), Direction.UP, extraArguments, false, outErrorMessage) || TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, position, direction, extraArguments, false, outErrorMessage);
    }

    private static boolean deployOnEntity(ITurtleAccess turtle, TurtlePlayer turtlePlayer) {
        Vec3 rayDir;
        Vec3 turtlePos;
        Level world = turtle.getLevel();
        HitResult hit = WorldUtil.clip(world, turtlePos = turtlePlayer.player().position(), rayDir = turtlePlayer.player().getViewVector(1.0f), 1.5, null);
        if (!(hit instanceof EntityHitResult)) {
            return false;
        }
        EntityHitResult entityHit = (EntityHitResult)hit;
        Entity hitEntity = entityHit.getEntity();
        Vec3 hitPos = entityHit.getLocation();
        DropConsumer.set(hitEntity, drop -> InventoryUtil.storeItemsFromOffset((Container)turtlePlayer.player().getInventory(), drop, 1));
        boolean placed = PlatformHelper.get().interactWithEntity(turtlePlayer.player(), hitEntity, hitPos);
        TurtleUtil.stopConsuming(turtle);
        return placed;
    }

    private static boolean canDeployOnBlock(BlockPlaceContext context, ITurtleAccess turtle, TurtlePlayer player, BlockPos position, Direction side, boolean allowReplaceable, @Nullable ErrorMessage outErrorMessage) {
        boolean isProtected;
        ServerLevel world = (ServerLevel)turtle.getLevel();
        if (!world.isInWorldBounds(position) || world.isEmptyBlock(position) || context.getItemInHand().getItem() instanceof BlockItem && WorldUtil.isLiquidBlock((Level)world, position)) {
            return false;
        }
        BlockState state = world.getBlockState(position);
        boolean replaceable = state.canBeReplaced(context);
        if (!allowReplaceable && replaceable) {
            return false;
        }
        boolean bl = isProtected = replaceable ? player.isBlockProtected(world, position) : player.isBlockProtected(world, position.relative(side));
        if (isProtected) {
            if (outErrorMessage != null) {
                outErrorMessage.message = "Cannot place in protected area";
            }
            return false;
        }
        return true;
    }

    public static BlockHitResult getHitResult(BlockPos position, Direction side) {
        double hitX = 0.5 + (double)side.getStepX() * 0.5;
        double hitY = 0.5 + (double)side.getStepY() * 0.5;
        double hitZ = 0.5 + (double)side.getStepZ() * 0.5;
        if (Math.abs(hitY - 0.5) < 0.01) {
            hitY = 0.45;
        }
        return new BlockHitResult(new Vec3((double)position.getX() + hitX, (double)position.getY() + hitY, (double)position.getZ() + hitZ), side, position, false);
    }

    private static boolean deployOnBlock(ItemStack stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer, BlockPos position, Direction side, @Nullable Object[] extraArguments, boolean adjacent, @Nullable ErrorMessage outErrorMessage) {
        Object object;
        Direction playerDir = side.getOpposite();
        BlockPos playerPosition = position.relative(side);
        turtlePlayer.setPosition(turtle, playerPosition, playerDir);
        BlockHitResult hit = TurtlePlaceCommand.getHitResult(position, side);
        UseOnContext context = new UseOnContext((Player)turtlePlayer.player(), InteractionHand.MAIN_HAND, hit);
        if (!TurtlePlaceCommand.canDeployOnBlock(new BlockPlaceContext(context), turtle, turtlePlayer, position, side, adjacent, outErrorMessage)) {
            return false;
        }
        Item item = stack.getItem();
        BlockEntity existingTile = turtle.getLevel().getBlockEntity(position);
        boolean placed = TurtlePlaceCommand.doDeployOnBlock(stack, turtlePlayer, hit, adjacent).consumesAction();
        if (placed && item instanceof SignItem && extraArguments != null && extraArguments.length >= 1 && (object = extraArguments[0]) instanceof String) {
            String message = (String)object;
            Level world = turtle.getLevel();
            BlockEntity tile = world.getBlockEntity(position);
            if (tile == null || tile == existingTile) {
                tile = world.getBlockEntity(position.relative(side));
            }
            if (tile instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)tile;
                TurtlePlaceCommand.setSignText(world, sign, message);
            }
        }
        return placed;
    }

    private static InteractionResult doDeployOnBlock(ItemStack stack, TurtlePlayer turtlePlayer, BlockHitResult hit, boolean adjacent) {
        Item item;
        PlatformHelper.UseOnResult result;
        PlatformHelper.UseOnResult useOnResult = result = PlatformHelper.get().useOn(turtlePlayer.player(), stack, hit);
        Objects.requireNonNull(useOnResult);
        PlatformHelper.UseOnResult useOnResult2 = useOnResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlatformHelper.UseOnResult.Handled.class, PlatformHelper.UseOnResult.Continue.class}, (Object)useOnResult2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                PlatformHelper.UseOnResult.Handled handled = (PlatformHelper.UseOnResult.Handled)useOnResult2;
                if (handled.result() == InteractionResult.PASS) break;
                return handled.result();
            }
            case 1: {
                InteractionResult useOnResult3;
                PlatformHelper.UseOnResult.Continue canUse = (PlatformHelper.UseOnResult.Continue)useOnResult2;
                ServerPlayer player = turtlePlayer.player();
                BlockState block = player.level().getBlockState(hit.getBlockPos());
                if (adjacent && canUse.block()) {
                    InteractionResult useWithoutItemResult;
                    ItemInteractionResult useItemOnResult = block.useItemOn(stack, player.level(), (Player)player, InteractionHand.MAIN_HAND, hit);
                    if (useItemOnResult.consumesAction()) {
                        return useItemOnResult.result();
                    }
                    if (useItemOnResult == ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION && block.is(ComputerCraftTags.Blocks.TURTLE_CAN_USE) && (useWithoutItemResult = block.useWithoutItem(player.level(), (Player)player, hit)).consumesAction()) {
                        return useWithoutItemResult;
                    }
                }
                if ((useOnResult3 = stack.useOn(new UseOnContext((Player)player, InteractionHand.MAIN_HAND, hit))) == InteractionResult.PASS) break;
                return useOnResult3;
            }
        }
        if ((item = stack.getItem()) instanceof BucketItem || item instanceof PlaceOnWaterBlockItem || stack.is(ComputerCraftTags.Items.TURTLE_CAN_PLACE)) {
            return turtlePlayer.player().gameMode.useItem(turtlePlayer.player(), turtlePlayer.player().level(), stack, InteractionHand.MAIN_HAND);
        }
        return InteractionResult.PASS;
    }

    private static void setSignText(Level world, SignBlockEntity sign, String message) {
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)message);
        int firstLine = lines.size() <= 2 ? 1 : 0;
        SignText signText = new SignText();
        int len = Math.min(lines.size(), 4);
        for (int i = 0; i < len; ++i) {
            String line = (String)lines.get(i);
            signText = signText.setMessage(i + firstLine, (Component)(line.length() > 15 ? Component.literal((String)line.substring(0, 15)) : Component.literal((String)line)));
        }
        sign.setText(signText, true);
        world.sendBlockUpdated(sign.getBlockPos(), sign.getBlockState(), sign.getBlockState(), 3);
    }

    private static final class ErrorMessage {
        @Nullable String message;

        private ErrorMessage() {
        }
    }
}

